LIBRARY IEEE; 
USE IEEE.std_logic_1164.ALL;
ENTITY dff IS
  PORT( d, clk : IN std_logic;
        q : OUT std_logic);
END dff;

ARCHITECTURE dff OF dff IS
BEGIN
  PROCESS(clk)
  BEGIN
    IF ( clk = '1') AND ( clk'EVENT ) THEN
      q <= d;
    END IF;
  END PROCESS;
END dff;




LIBRARY IEEE; 
USE IEEE.std_logic_1164.ALL;
ENTITY dff IS
  GENERIC ( setup_time, hold_time : TIME );
  PORT( d, clk : IN std_logic;
        q : OUT std_logic);
BEGIN
  setup_check : PROCESS ( clk )
  BEGIN
    IF ( clk = '1' ) and ( clk'EVENT ) THEN
      ASSERT ( d'LAST_EVENT >= setup_time )
        REPORT "setup violation"
        SEVERITY ERROR;
    END IF;
  END PROCESS setup_check;
END dff;

ARCHITECTURE dff_behave OF dff IS
BEGIN
  dff_process : PROCESS ( clk )
  BEGIN
    IF ( clk = '1' ) AND ( clk'EVENT ) THEN
      q <= d;
    END IF;
  END PROCESS dff_process;
END dff_behave;

